import {type Router} from '../types';
import {css} from '../css';
import {Layout} from '../components/Layout';
import {Navigation} from '../components/Navigation';
import {Main} from '../components/Main';

export async function homeRouter(r: Router) {
  r.get('', async ctx => {
    return ctx.html(
      <Layout title="TriFrost Mini Website - Home">
        <>
          <Navigation active="home" />
          <Main>
            <h1>Welcome to TriFrost</h1>
            <p className={css({marginTop: css.$v.space_l})}>
              TriFrost is not just another server framework. Whether you deploy to Node.js, Bun, or edge runtimes like Cloudflare Workers,
              TriFrost delivers top-tier performance, developer ergonomics, and observability baked in.
            </p>
            <p className={css({marginTop: css.$v.space_l})}>
              🔧 Build robust APIs, ⚡ serve blazing-fast pages, and 🌍 scale effortlessly across runtimes.
            </p>
            <section className={css({marginTop: css.$v.space_xl})}>
              <h2>Key Highlights</h2>
              <ul
                className={css.use('f', 'fv', 'text_body', {
                  marginTop: css.$v.space_m,
                  marginLeft: css.$v.space_l,
                  gap: css.$v.space_l,
                  listStyle: 'disc',
                })}
              >
                <li>✨ Middleware-first design, inspired by Koa but runtime-agnostic</li>
                <li>📦 Zero-config JSX rendering for server-driven UIs</li>
                <li>📊 First-class observability with OpenTelemetry</li>
                <li>🛡️ Built-in security and CORS support out of the box</li>
                <li>💥 Runs on Node.js, Bun, Cloudflare Workers, and more</li>
              </ul>
            </section>
          </Main>
        </>
      </Layout>,
    );
  });
}
