import {css} from '../../css';
import {type Post} from './types';

export function CommentForm(props: {post: Post}) {
  return (
    <form
      hx-post={`/blog/${props.post.id}/comment`}
      hx-target="#comment-list"
      hx-swap="outerHTML"
      className={css.use('f', 'fh', {marginTop: css.$v.space_m, gap: css.$v.space_l})}
    >
      <input
        type="text"
        name="comment"
        placeholder="Your comment"
        required
        className={css.use('input', {fontSize: '1.8rem', padding: css.$v.space_l, flexGrow: 1})}
      />
      <button type="submit" className={css.use('button', {fontSize: '1.8rem', padding: css.$v.space_l})}>
        Submit
      </button>
    </form>
  );
}
