import {type Router} from '../types';
import {css} from '../css';
import {Layout} from '../components/Layout';
import {Navigation} from '../components/Navigation';
import {Main} from '../components/Main';

export async function aboutRouter(r: Router) {
  r.get('', async ctx => {
    return ctx.html(
      <Layout title="TriFrost Mini Website - About">
        <>
          <Navigation active="about" />
          <Main>
            <h1>About TriFrost</h1>
            <p className={css({marginTop: css.$v.space_l})}>
              TriFrost began with a bold idea: can we build a server framework that feels as ergonomic as Koa, runs as fast as uWS, and
              deploys anywhere from serverless edges to traditional cloud VMs?
            </p>
            <p className={css({marginTop: css.$v.space_l})}>
              After years of production experience across runtimes, we created TriFrost to unify the backend experience — no more
              one-size-fits-some frameworks. With TriFrost, developers get a consistent, high-performance foundation with transparent
              observability, middleware composability, and top-tier TypeScript support.
            </p>
            <section className={css({marginTop: css.$v.space_xl})}>
              <h2>Our Mission</h2>
              <ul
                className={css.use('f', 'fv', 'text_body', {
                  marginTop: css.$v.space_m,
                  marginLeft: css.$v.space_l,
                  gap: css.$v.space_l,
                  listStyle: 'disc',
                })}
              >
                <li>💡 Empower developers to build faster, more reliable apps</li>
                <li>🧩 Provide a modular, composable toolkit — no magic, no lock-in</li>
                <li>🚀 Push the limits of what’s possible across modern runtimes</li>
                <li>🌐 Champion open-source innovation and community-driven growth</li>
              </ul>
            </section>
          </Main>
        </>
      </Layout>,
    );
  });
}
