import {App, Security, Cors} from '@trifrost/core';
import {type Env} from './types';
import {homeRouter} from './pages/home';
import {aboutRouter} from './pages/about';
import {blogRouter} from './pages/blog';
import {notFoundHandler} from './pages/notfound';
import {css} from './css';

new App<Env>({
  client: {css},
  // tracing: {
  // exporters: ({ env }) => [
  // new OtelHttpExporter({
  //     logEndpoint: 'https://ingest.YOUR_SIGNOZ_INSTANCE/v1/logs',
  //     spanEndpoint: 'https://ingest.YOUR_SIGNOZ_INSTANCE/v1/traces',
  //     headers: {
  //         'signoz-access-token': env.SIGNOZ_API_TOKEN,
  //     },
  // }),
  // ],
  // },
})
  .use(Security())
  .use(Cors())
  .group('/', homeRouter)
  .group('/about', aboutRouter)
  .group('/blog', blogRouter)
  .get('/hello', ctx => ctx.text('Hello World'))
  .onNotFound(notFoundHandler)
  .boot({port: Number(process.env.PORT || 3000)});
