import {createCss} from '@trifrost/core';

export const css = createCss({
  reset: true,
  var: {
    font_header: "'Fira Code', monospace",
    font_body: "'Roboto', Sans-serif",
    radius: '0.5rem',
    space_s: '0.5rem',
    space_m: '1rem',
    space_l: '2rem',
    space_xl: '4rem',
  },
  theme: {
    bg: {
      light: '#f9fafb',
      dark: '#1f2937',
    },
    fg: {
      light: '#1f2937',
      dark: '#f9fafb',
    },
    nav_bg: {
      dark: '#020810',
      light: '#c7c7c7',
    },
    nav_fg: {
      dark: '#ffffff',
      light: '#000000',
    },
    input_bg: {
      dark: '#020810',
      light: '#e1e1e1',
    },
    input_fg: {
      dark: '#ffffff',
      light: '#000000',
    },
    button_bg: {
      dark: '#020810',
      light: '#e1e1e1',
    },
    button_fg: {
      dark: '#ffffff',
      light: '#000000',
    },
    panel_bg: {
      dark: '#0d141d',
      light: '#ededed',
    },
    panel_fg: {
      dark: '#ffffff',
      light: '#000000',
    },
  },
  definitions: mod => ({
    f: () => ({display: 'flex'}),
    fh: () => ({flexDirection: 'row'}),
    fv: () => ({flexDirection: 'column'}),
    fa_c: () => ({alignItems: 'center'}),
    fj_c: () => ({justifyContent: 'center'}),
    sm_v_l: () => ({marginBottom: mod.$v.space_l, marginTop: mod.$v.space_l}),
    text_header: () => ({
      fontFamily: mod.$v.font_header,
      fontWeight: 'bold',
      [mod.media.desktop]: {
        fontSize: '2.2rem',
      },
      [mod.media.tablet]: {
        fontSize: '2rem',
      },
    }),
    text_title: () => ({
      fontFamily: mod.$v.font_header,
      fontWeight: 'bold',
      fontSize: '2rem',
    }),
    text_body: () => ({
      fontFamily: mod.$v.font_body,
      lineHeight: 1.4,
      fontSize: '1.8rem',
    }),
    input: () => ({
      appearance: 'none',
      flexShrink: 0,
      fontFamily: mod.$v.font_body,
      fontWeight: 400,
      border: 'none',
      borderRadius: mod.$v.radius,
      background: mod.$t.input_bg,
      color: mod.$t.input_fg,
    }),
    button: () => ({
      appearance: 'none',
      flexShrink: 0,
      fontFamily: mod.$v.font_body,
      fontWeight: 600,
      border: 'none',
      borderRadius: mod.$v.radius,
      background: mod.$t.button_bg,
      color: mod.$t.button_fg,
      cursor: 'pointer',
      [mod.is(`${mod.hover}, ${mod.active}`)]: {
        boxShadow: '0 0 0 2px ' + mod.$t.fg,
      },
    }),
    panel: () => ({
      width: '100%',
      backgroundColor: mod.$t.panel_bg,
      color: mod.$t.panel_fg,
      borderRadius: mod.$v.radius,
    }),
  }),
  themeAttribute: true,
});
