import {css} from '../css';

const LIST = [
  {to: '/', label: 'Home', name: 'home'},
  {to: '/about', label: 'About', name: 'about'},
  {to: '/blog', label: 'Blog', name: 'blog'},
] as const;

type NavigationProps = {
  active: (typeof LIST)[number]['name'];
};

export function Navigation({active}: NavigationProps) {
  const cls = css.use('f', 'fh', 'fa_c', 'fj_c', 'sm_v_l', {
    gap: css.$v.space_l,
    padding: css.$v.space_l,
    [css.media.desktop]: {width: '90rem'},
    [css.media.tablet]: {width: '100%'},
  });

  const clsItem = css({
    borderRadius: css.$v.radius,
    padding: `${css.$v.space_m} ${css.$v.space_l}`,
    color: css.$t.fg,
    textDecoration: 'none',
    cursor: 'pointer',
    fontFamily: css.$v.font_header,
    fontSize: '2rem',
    fontWeight: 600,
    [`${css.hover},${css.is('[data-active]')}`]: {
      background: css.$t.nav_bg,
      color: css.$t.nav_fg,
    },
  });

  return (
    <nav className={cls}>
      {LIST.map(el => (
        <a className={clsItem} href={el.to} {...(el.name === active && {'data-active': true})}>
          {el.label}
        </a>
      ))}
    </nav>
  );
}
