# TriFrost Mini Site Example

This is a **Node.js + containerized** example of a TriFrost-powered mini website, showcasing:

- A home page, about page, and blog page with hardcoded posts  
- Helmet-Like security headers and Cors out-of-the-box
- HTMX-powered comment interactions  
- Theming with light/dark mode  
- Container-ready setup with **Podman** and `podman-compose`  
- (Optional) SigNoz integration for OpenTelemetry tracing  

### Runing as a container (podman)
If not yet installed, install [Podman](https://podman.io) and `podman-compose`

```bash
podman-compose build
podman-compose up
```

### Running Locally without a container
If not yet installed, install NodeJS (v20+ recommended)
```bash
npm install
npm run dev
```

### Access the site
```
http://localhost:3000
```

## ⚙ Environment Variables
Create a `.env` file based on the example:

### .env.example
```
PORT=3000
SIGNOZ_API_TOKEN=
```
- `PORT`: Port the server listens on (default: 3000)
- `SIGNOZ_API_TOKEN`: (Optional) SigNoz API token for OpenTelemetry tracing

### Enabling Observability (SigNoz)
If you want to enable tracing via [SigNoz](https://signoz.io):
1. Deploy or access your SigNoz instance.
2. Get your `SIGNOZ_API_TOKEN` (API key/token for authentication).
3. Add it to the `.env` file at the root of your project:
```ini
SIGNOZ_API_TOKEN='your-signoz-api-token-here'
```
4. Uncomment the `OtelHttpExporter` block in `src/index.ts` to enable the exporter.

> Note: TriFrost will automatically include the app’s name and version (from `src/index.ts`) in each trace span — no extra config needed!

## 📚 Notes
- This example includes containerization with **Podman** for easy deployment but can also run standalone on Node.js.
- You can extend the container setup with custom networks, volumes, or multi-stage builds as needed.
- Explore the code and modify routes, components, and styles to fit your use case!
- There is a `install.sh` script included in the files, due to the way we're mounting node_volumes if you find that VSCode (or whichever editor you're using) is giving warnings feel free to run this to install dependencies (locally + in container), just run `sh install.sh` and you're good to go.

### Tech Stack
- [TriFrost](https://trifrost.dev) – Runtime-agnostic server framework with JSX rendering
- [HTMX](https://htmx.org/) – Attribute-driven frontend interactivity
- [NodeJS](https://nodejs.org/) – JavaScript runtime environment
- [Podman](https://podman.io) - Open Source container tooling
- [SigNoz](https://signoz.io) – OpenTelemetry-compatible observability

---

Built by [Peter Vermeulen](https://github.com/peterver) and the [TriFrost community](https://trifrost.dev).

Feel free to reach out or contribute improvements! 🚀
