import {Layout} from '../components/Layout';
import {css} from '../css';
import {type Context} from '../types';

export function notFoundHandler(ctx: Context) {
  return ctx.html(
    <Layout>
      <div className={css.use('f', 'fv', 'fa_c', 'fj_c', {width: '100%', height: '100%', textAlign: 'center'})}>
        <h1 style={{fontSize: '10rem', opacity: 0.2}}>404</h1>
        <p>The page you are looking for could not be found</p>
        <a
          href="/"
          className={css.use('text_body', {
            color: css.$t.fg,
            fontSize: '1.6rem',
            marginTop: css.$v.space_xl,
          })}
        >
          Back to Safety
        </a>
      </div>
    </Layout>,
    {status: 404},
  );
}
