import {format} from '@valkyriestudios/utils/date/format';
import {css} from '../../css';
import {type Post} from './types';

export function CommentList(props: {post: Post; inject: boolean}) {
  const cls = css(
    css.mix('f', 'fv', {
      marginTop: css.$v.space_l,
      p: css.mix('panel', {
        padding: css.$v.space_l,
        textAlign: 'center',
        opacity: 0.5,
      }),
      ul: css.mix('f', 'fv', {gap: css.$v.space_l}),
      li: css.mix('f', 'fv', 'text_body', 'panel', {
        padding: css.$v.space_l,
        paddingRight: '6rem',
        position: 'relative',
        small: {
          fontSize: '1.6rem',
          opacity: 0.8,
          marginTop: css.$v.space_s,
        },
        [css.nthOfType(1)]: {
          animation: `${css.keyframes({
            from: {opacity: 0},
            to: {opacity: 1},
          })} .5s ease-in-out`,
        },
      }),
      button: css.mix('button', {
        position: 'absolute',
        top: css.$v.space_l,
        right: css.$v.space_l,
        padding: css.$v.space_s,
        fontSize: '1.6rem',
      }),
    }),
  ); /* Note the inject here, this prevents css from being injected during htmx replacement renders */

  return (
    <div id="comment-list" className={cls}>
      {!props.post.comments.length ? (
        <p>Be the first one to leave a comment</p>
      ) : (
        <ul>
          {props.post.comments.map(el => (
            <li id={`comment-${el.id}`}>
              <span>{el.body}</span>
              <small>{format(el.on, 'YYYY-MM-DD HH:mm:ss')}</small>
              <button type="button" hx-delete={`/blog/${props.post.id}/comment/${el.id}`} hx-target="#comment-list" hx-swap="outerHTML">
                delete
              </button>
            </li>
          ))}
        </ul>
      )}
    </div>
  );
}
