import {css} from '../css';
import {Footer} from './Footer';

type LayoutProps = {
  title?: string;
  children: JSX.Element;
};

export function Layout({title = 'TriFrost Example', children}: LayoutProps) {
  /* Root style injection */
  css.root({
    fontSize: '62.5%',
    minHeight: '100vh',
    p: css.mix('text_body'),
    h1: css.mix('text_header'),
    h2: css.mix('text_title'),
    a: {[css.visited]: {color: css.$t.fg}},
  });

  return (
    <html>
      <head>
        <meta charset="utf-8" />
        <title>{title}</title>
        {/* Fonts */}
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
        <link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@300..700&display=swap" rel="stylesheet" />
        <link href="https://fonts.googleapis.com/css2?family=Roboto:ital@0;1&display=swap" rel="stylesheet"></link>
        {/* HTMX */}
        <script
          src="https://cdnjs.cloudflare.com/ajax/libs/htmx/2.0.4/htmx.min.js"
          integrity="sha512-2kIcAizYXhIn8TzUvqzEDZNuDZ+aW7yE/+f1HJHXFjQcGNfv1kqzJSTBRBSlOgp6B/KZsz1K0a3ZTqP9dnxioQ=="
          crossorigin="anonymous"
          referrerpolicy="no-referrer"
        ></script>
      </head>
      <body
        className={css.use('f', 'fv', 'fa_c', 'fj_c', {
          backgroundColor: css.$t.bg,
          color: css.$t.fg,
          padding: css.$v.space_l,
          minHeight: '100vh',
        })}
      >
        {children}
        <Footer />
      </body>
    </html>
  );
}
