# TriFrost + HTMX Todo App

This example shows how to build a fully interactive, server-rendered todo app using [TriFrost](https://trifrost.dev) and [HTMX](https://htmx.org). No frontend framework needed — just HTML, JSX, and HTMX.

TriFrost handles routing, caching, and rendering on the server. HTMX handles interactivity via declarative HTML attributes. Together, they let you build powerful apps without sacrificing performance or simplicity.

👉 **Live demo:** [TriFrost + HTMX: Todos](https://trifrost_htmx_todos.contact-cae.workers.dev/)

### Running Locally
```bash
npm install
npm run dev
```

That’s it! Your app will boot in development mode using Cloudflare’s local simulation.

### Enabling Observability (Uptrace)
If you want to enable tracing via [Uptrace](https://uptrace.dev/):
1. Create an account at [uptrace.dev](https://uptrace.dev/)
2. Get your `UPTRACE_DSN` string
3. Add it to the `.dev.vars` file at the root of your project:
```ini
UPTRACE_DSN='your-uptrace-dsn-here'
```

When set, TriFrost will automatically stream traces using OpenTelemetry.

**Take Note**: By default the `JsonExporter` has been enabled in this example.

### Deploying to Cloudflare
1. Open `wrangler.toml` and set a unique name for your project:
```toml
name = "your-app-name"
```
2. Deploy it live
```bash
npm run deploy
```

### Enabling Uptrace in Production
To connect Uptrace on your deployed app:
```bash
npx wrangler secret put UPTRACE_DSN
```

Paste in your DSN when prompted.

TriFrost will automatically include the app’s name and version (from `src/index.tsx`) in each trace span — no extra config needed.

### Tech Stack
- [TriFrost](https://trifrost.dev) – Runtime-agnostic server framework with JSX rendering
- [HTMX](https://htmx.org/) – Attribute-driven frontend interactivity
- [Cloudflare Workers](https://workers.cloudflare.com/) – Edge deployment & Durable Objects
- [Uptrace](https://uptrace.dev) – OpenTelemetry-compatible observability

---

Built by [Peter Vermeulen](https://github.com/peterver) and the [TriFrost community](https://trifrost.dev).
