import {createCss} from '@trifrost/core';

export const css = createCss({
  reset: true,
  var: {
    space_s: '.5rem',
    space_m: '1rem',
    space_l: '2rem',
    radius: '.4rem',
  },
  theme: {
    body_bg: '#f6f8fa',
    body_fg: '#333333',
    empty_bg: '#ededed',
    empty_fg: '#666',
  },
  definitions: mod => ({
    f: () => ({display: 'flex'}),
    fv: () => ({flexDirection: 'column'}),
    fh: () => ({flexDirection: 'row'}),
    fa_c: () => ({alignItems: 'center'}),
    title: () => ({
      fontSize: '1.8rem',
      fontWeight: 600,
    }),
    form: () => ({
      display: 'flex',
      margin: `${mod.$v.space_m} 0`,
    }),
    button: () => ({
      appearance: 'none',
      backgroundColor: 'black',
      color: 'white',
      border: 'none',
      cursor: 'pointer',
      textAlign: 'center',
      flexShrink: 0,
      borderRadius: mod.$v.radius,
      fontWeight: 600,
      [mod.hover]: {
        backgroundColor: '#333',
      },
    }),
    button_l: () => ({
      lineHeight: '3rem',
      padding: `0 ${mod.$v.space_m}`,
      fontSize: '1rem',
    }),
    button_s: () => ({
      lineHeight: '2rem',
      padding: `0 ${mod.$v.space_s}`,
      fontSize: '.8rem',
    }),
    form_el: () => ({
      fontSize: '1rem',
      height: '3rem',
      padding: `0 ${mod.$v.space_m}`,
      borderRadius: mod.$v.radius,
    }),
    form_icon: () => ({
      fontSize: '1rem',
      height: '2rem',
      width: '2rem',
      display: 'inline-block',
      flexShrink: '0',
    }),
  }),
});
