import {css} from '../css';

export type Todo = {
  id: string;
  text: string;
  completed?: boolean;
};

export function TodoForm() {
  return (
    <form className={css.use('form', {gap: css.$v.space_m})} hx-post="/" hx-trigger="submit" hx-target="#todo-list" hx-swap="outerHTML">
      <input type="text" name="text" required placeholder="Add new todo..." className={css.use('form_el', {flexGrow: 1})} />
      <button type="submit" className={css.use('button', 'button_l')}>
        Add
      </button>
    </form>
  );
}

export function TodoList(props: {children?: any; todos: Todo[]}) {
  const todos = props.todos || [];
  const hasTodos = todos.length > 0;

  return (
    <section id="todo-list">
      {!hasTodos && (
        <p
          className={css({
            textAlign: 'center',
            padding: css.$v.space_l,
            backgroundColor: css.$t.empty_bg,
            borderRadius: css.$v.radius,
            color: css.$t.empty_fg,
          })}
        >
          <em>No todos yet</em>
        </p>
      )}
      {hasTodos && (
        <form
          className={css.use('f', 'fv', 'form', {alignItems: 'flex-start'})}
          hx-post="/complete"
          hx-trigger="submit"
          hx-target="#todo-list"
          hx-swap="outerHTML"
        >
          <ul style={{width: '100%'}}>
            {todos.map(t => (
              <li
                key={t.id}
                id={`todo-${t.id}`}
                className={css.use('f', 'fa_c', {
                  gap: css.$v.space_s,
                  width: '100%',
                  maxWidth: '100%',
                })}
              >
                <input type="checkbox" name="done" value={t.id} disabled={t.completed} className={css.use('form_icon')} />
                <span
                  className={css.use({
                    flexGrow: 1,
                    overflow: 'hidden',
                    textOverflow: 'ellipsis',
                    textDecoration: t.completed ? 'line-through' : 'none',
                  })}
                >
                  {t.text}
                </span>
                <button
                  type="button"
                  className={css.use('button', 'button_s')}
                  hx-delete={`/${t.id}`}
                  hx-target="#todo-list"
                  hx-swap="outerHTML"
                >
                  Remove
                </button>
              </li>
            ))}
          </ul>
          <button type="submit" className={css.use('button', 'button_l', {marginTop: css.$v.space_m})}>
            Complete
          </button>
        </form>
      )}
    </section>
  );
}
