import {css} from '../css';

export function Layout(props: {children: any}) {
  return (
    <html lang="en">
      <head>
        <title>TriFrost & HTMX | Todos</title>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta name="description" content="Manage your todos with TriFrost and HTMX" />
        <script src="https://unpkg.com/htmx.org"></script>
      </head>
      <body
        className={css.use('f', 'fv', 'fa_c', {
          fontFamily: 'system-ui, sans-serif',
          background: css.$t.body_bg,
          color: css.$t.body_fg,
          padding: css.$v.space_l,
          margin: 0,
          minHeight: '100vh',
        })}
      >
        {props.children}
      </body>
    </html>
  );
}
